/*
 * Decompiled with CFR 0.152.
 */
package screens.elements;

import game.Apearance;
import javax.microedition.lcdui.Graphics;
import main.GameManager;
import screens.MenuScreen;

public class MenuField {
    public static int menuFieldHeightCurrent = 0;
    public static int menuFieldHeightCurrentBlocked = 0;
    public static int menuFieldHeightCurrentMax = -1;
    public static int menuFieldHeightRequested = -1;
    public static boolean isAnimationFieldResizeInProgress = false;

    public static boolean paint_MenuBackground(Graphics g) {
        if (GameManager.imgCurrentImage != null) {
            g.drawImage(GameManager.imgCurrentImage, GameManager.current.getWidth() / 2, GameManager.current.getHeight() / 2, 3);
        }
        System.out.println("menuFieldHeightCurrent = " + menuFieldHeightCurrent);
        if (menuFieldHeightCurrent <= 0) {
            return false;
        }
        g.setColor(MenuScreen.MENU_FIELD_BORDER_COLOR);
        menuFieldHeightCurrentBlocked = menuFieldHeightCurrent;
        int top = GameManager.current.getHeight() / 2 - menuFieldHeightCurrentBlocked;
        g.setClip(0, top, GameManager.current.getWidth(), 2 * menuFieldHeightCurrentBlocked);
        if (GameManager.imgTransparent != null) {
            g.drawImage(GameManager.imgTransparent, GameManager.current.getWidth() / 2, GameManager.current.getHeight() / 2, 3);
        } else {
            int bottom = GameManager.current.getHeight() / 2 + menuFieldHeightCurrentBlocked;
            g.setColor(Apearance.COLOR_MENU_BACKGROUND_TRANSPARENT);
            g.fillRect(0, top, GameManager.current.getWidth(), bottom);
            g.setColor(Apearance.COLOR_BLACK);
        }
        return true;
    }

    public static void drawMenuBorders(Graphics g) {
        g.setClip(0, 0, GameManager.current.getWidth(), GameManager.current.getHeight());
        g.setColor(0);
        int top = GameManager.current.getHeight() / 2 - menuFieldHeightCurrentBlocked;
        int bottom = GameManager.current.getHeight() / 2 + menuFieldHeightCurrentBlocked;
        g.drawLine(0, top, GameManager.current.getWidth(), top);
        g.drawLine(0, bottom - 1, GameManager.current.getWidth(), bottom - 1);
    }

    public static void menuOpenAnimation() throws InterruptedException {
        while (menuFieldHeightCurrent < menuFieldHeightRequested) {
            int step = Math.max(menuFieldHeightRequested / MenuScreen.MENU_ANIMATION_OPENING_SPEED, MenuScreen.MENU_ANIMATION_OPENING_MIN_SPEED);
            menuFieldHeightCurrent += step;
            menuFieldHeightCurrent = Math.min(menuFieldHeightCurrent, menuFieldHeightRequested);
            GameManager.current.repaint();
            Thread.sleep(MenuScreen.MENU_ANIMATION_BASE_INTERVAL);
        }
    }

    public static void menuCloseAnimation() throws InterruptedException {
        if (menuFieldHeightRequested < 0) {
            menuFieldHeightRequested = menuFieldHeightCurrent;
        }
        while (menuFieldHeightCurrent > 0) {
            int newMenuFieldHeightCurrent;
            int step = menuFieldHeightCurrentMax / MenuScreen.MENU_ANIMATION_CLOSING_SPEED;
            menuFieldHeightCurrent -= step;
            menuFieldHeightCurrent = newMenuFieldHeightCurrent = Math.max(menuFieldHeightCurrent, 0);
            GameManager.current.repaint();
            Thread.sleep(MenuScreen.MENU_ANIMATION_BASE_INTERVAL);
        }
    }
}

